/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.store;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.ExternalStoreActivity;
import cz.insophy.inplan.store.MaterialQuotas;
import cz.insophy.inplan.store.StoreActivity;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

class BackwardMaterialQuotas
extends MaterialQuotas {
    protected HashMap<Material, BackwardQuota> quotas = Maps.newHashMap();
    protected HashMap<Material, ListIterator<StoreActivity>> iters = Maps.newHashMap();

    protected BackwardMaterialQuotas(Collection<Material> materials, long time, long matHorizonBase, StoreSchedule.MatHorizonTreatment matHorizonTreatment, StoreSchedule storeSchedule, Predicate<StoreActivity> saPredicate) {
        super(time, storeSchedule, matHorizonBase, matHorizonTreatment);
        for (Material material : materials) {
            long absMatHorizon = this.getAbsoluteMatHorizon(material, matHorizonBase, matHorizonTreatment);
            saPredicate = Predicates.and(saPredicate, new IsBeforeMatHorizon(absMatHorizon));
            ArrayList<StoreActivity> matList = Lists.newArrayList(Iterables.filter(storeSchedule.getActivities(material), saPredicate));
            if (GeneralizedRequest.isDateValid(absMatHorizon)) {
                matList.add(new ExternalStoreActivity(absMatHorizon, material, Double.POSITIVE_INFINITY));
            }
            double q = 0.0;
            double minq = 0.0;
            int timePos = 0;
            double timeQ = 0.0;
            ListIterator it = matList.listIterator();
            while (it.hasNext()) {
                StoreActivity a = (StoreActivity)it.next();
                q += a.getQty();
                if (a.getTime() > time) {
                    if (!(minq > q)) continue;
                    minq = q;
                    continue;
                }
                ++timePos;
                minq = q;
                timeQ = q;
            }
            this.quotas.put(material, new BackwardQuota(minq, timeQ));
            if (timePos <= 0) continue;
            this.iters.put(material, matList.listIterator(timePos));
        }
    }

    protected void changeQty(MaterialQuotas.MaterialQuota quota, double delta) {
        BackwardQuota mq = (BackwardQuota)quota;
        mq.qty += delta;
        if (mq.qty < mq.quota) {
            mq.quota = mq.qty;
        }
        if (mq.quota < 0.0) {
            mq.quota = 0.0;
        }
    }

    @Override
    protected void changeQuota(MaterialQuotas.MaterialQuota quota, double delta) {
        BackwardQuota mq = (BackwardQuota)quota;
        mq.quota += delta;
        if (mq.quota < 0.0) {
            mq.quota = 0.0;
        }
    }

    @Override
    public void setTime(long time) {
        if (time > this.lastTime) {
            throw new IllegalArgumentException("Successive calls to setTime must be done with non-increasing times.");
        }
        this.lastTime = time;
        if (this.iters.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Material, ListIterator<StoreActivity>>> entryIter = this.iters.entrySet().iterator();
        while (entryIter.hasNext()) {
            Map.Entry<Material, ListIterator<StoreActivity>> entry = entryIter.next();
            Material material = entry.getKey();
            ListIterator<StoreActivity> iter = entry.getValue();
            StoreActivity a = null;
            while (iter.hasPrevious() && (a = iter.previous()).getTime() > time) {
                this.changeQty(this.quotas.get(material), -a.getQty());
            }
            if (a != null && a.getTime() <= time) {
                iter.next();
                continue;
            }
            entryIter.remove();
        }
    }

    @Override
    public Long getMaterialAvailableTime(Material mat, double qty) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Map<Material, ? extends MaterialQuotas.MaterialQuota> getQuotas() {
        return this.quotas;
    }

    protected static class IsBeforeMatHorizon
    implements Predicate<StoreActivity> {
        long absoluteMatHorizon;

        protected IsBeforeMatHorizon(long absoluteMatHorizon) {
            this.absoluteMatHorizon = absoluteMatHorizon;
        }

        @Override
        public boolean apply(StoreActivity input) {
            return !GeneralizedRequest.isDateValid(this.absoluteMatHorizon) || input.getTime() < this.absoluteMatHorizon;
        }
    }

    protected static class BackwardQuota
    implements MaterialQuotas.MaterialQuota {
        public double qty;
        public double quota;

        public BackwardQuota(double quota, double qty) {
            this.quota = quota;
            this.qty = qty;
        }

        @Override
        public double getQuota() {
            return this.quota;
        }

        public String toString() {
            return String.format("(quota=%f qty=%f)", this.quota, this.qty);
        }
    }
}

